package kom.itbeankit.common.message;

import java.awt.*;


public class Messenger extends java.awt.TextArea implements MessageListener
{

	public Messenger()
	{
		//{{INIT_CONTROLS
		setSize(0,0);
		//}}
	}
	//{{DECLARE_CONTROLS
	//}}

    public void deliverMessage(MessageEvent me){
        if(me != null){
            String fromString = " " + MessageTexts.MSG_FROM + " " +
                                me.getMsgSource() ;
            if(me.getMsgSource().equals(""))
                fromString = "";

            int displayType = me.getDisplayType();
            switch(displayType){
                case MessageEvent.DISPLAY_TYPE_TEXTAREA:
                    //example "INFO from host1: collision detected!"
                    appendText( getEventTypeString(me.getMsgType()) +
                                 fromString + ": "+
                                 me.getMsg() + "\n");
                break;
                case MessageEvent.DISPLAY_TYPE_DIALOG:
                    openDialog(me);
                break;
                case MessageEvent.DISPLAY_TYPE_BOTH:
                    openDialog(me);
                    //example "INFO from host1: collision detected!"
                    appendText( getEventTypeString(me.getMsgType()) +
                                 fromString + ": "+
                                 me.getMsg() + "\n");
                break;
                default:
            }
        }
    }
   
    void openDialog(MessageEvent me){
	    //find the frame for Dialog
	    Component c = this;
		while(!(c instanceof java.awt.Frame)){
		    c = c.getParent();
		}
		new MessageDialog((Frame)c,me).setVisible(true);
    }
    
    
    String getEventTypeString(int msgType){
        switch(msgType){
            case MessageEvent.MSG_TYPE_INFO :
                return MessageTexts.MSG_TYPE_INFO;
            case MessageEvent.MSG_TYPE_WARNING :
                return MessageTexts.MSG_TYPE_WARNING;
            case MessageEvent.MSG_TYPE_ERROR :
                return MessageTexts.MSG_TYPE_ERROR;
            case MessageEvent.MSG_TYPE_QUESTION :
                return MessageTexts.MSG_TYPE_QUESTION;
            default:
        }
        return "";
    }
	
	static public void main(String args[])
	{
		class DriverFrame extends java.awt.Frame {
			public DriverFrame() {
				addWindowListener(new java.awt.event.WindowAdapter() {
					public void windowClosing(java.awt.event.WindowEvent event)
					{
						dispose();	  // free the system resources
						System.exit(0); // close the application
					}
				});
				this.setLayout(new java.awt.BorderLayout());
				this.setSize(300,300);
				this.add(new Messenger());
			}
		}

		new DriverFrame().show();
	}


}